﻿using Microsoft.Crm.Sdk.Messages;
using Microsoft.Xrm.Sdk;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace VA.PPMS.Context
{
    [DataContract]
    [KnownType(typeof(Account))]
    [KnownType(typeof(MapperResultDetail))]
    public class MapperResult
    {
        private List<MapperResultDetail> _details;

        [DataMember]
        public IList<MapperResultDetail> Details => _details ?? (_details = new List<MapperResultDetail>());

        public MapperResult()
        {}

        public MapperResult(string validationMessage)
        {
            Details.Add(new MapperResultDetail(validationMessage));
        }

        public void Add(Account entity)
        {
            Details.Add(new MapperResultDetail() { Provider = entity });
        }

        public void Add(IEnumerable<Account> list)
        {
            foreach (var item in list)
            {
                Add(item);
            }
        }

        public void Add(IList<MapperResultDetail> details)
        {
            if (details == null)
                return;

            foreach (var detail in details)
            {
                Add(detail);
            }
        }

        public void Add(MapperResultDetail detail)
        {
            Details.Add(detail);
        }

        public void Add(SetStateRequest request)
        {
            Details.Add(new MapperResultDetail() { Requests = new List<SetStateRequest>() { request } });
        }

        public void Add(IList<SetStateRequest> requests)
        {
            Details.Add(new MapperResultDetail { Requests = requests });
        }

        public Entity FindProvider(string providerId)
        {
            var provider = Details.FirstOrDefault(p => p.SchemaId == providerId);
            if (!string.IsNullOrEmpty(provider?.SchemaId))
            {
                return provider.Provider;
            }
            return null;
        }
    }
}